<?php
/**
 * ˹
 *
 * @author һ yandy@yanwee.com
 * @package 1.0
 * @version $Id$
 */

/**
 * ͷ˹
 * @package Apps
 */
class Consign {

	/**
	 * @var Object $db ݿѯ
	 * @access private
	 */
	var $db = NULL;
	
	/**
	 * 
	 *
	 * @var string
	 */
	var $tName = "fke_house_consign";
	
	/**
	 * ίеľ˱
	 *
	 * @var string
	 */
	var $tNameBroker = "fke_house_consign_broker";
	
	/**
	 * 캯
	 *
	 * @param source $db
	 */
	function __construct($db) {
		$this->db = $db;
	}
	
	/**
	 * Ϣ
	 * @access public
	 * 
	 * @param array $memberInfo
	 * @return bool
	 **/
	 function save($info){
	 	
	 	$insertField = array(
	 		'consign_type'=>$info['consign_type'],
			'house_id'=>$info['id'],
			'owner_id'=>$info['owner_id'],
			'add_time'=>time(),
			'available_time'=>$info['available_time'],
			'consign_status'=>1,
	 	);
	 	$this->db->insert($this->tName,$insertField);
	 	$consign_id =  $this->db->getInsertId();
	 	
	 	if($info['brokerSelected']){
	 		$brokerList = explode(',',$info['brokerSelected']);
	 		array_remove_empty($brokerList);
	 		foreach ($brokerList as $item){
	 			$insertField = array(
			 		'consign_id'=>$consign_id,
					'broker_id'=>$item,
					'status'=>0
			 	);
			 	$this->db->insert($this->tNameBroker,$insertField);
	 		}
	 	}
	 	return true;
	 }
	 	 
	 /**
	 * ȡϢб
	 * @access public
	 * 
	 * @param array $pageLimit
	 * @return array
	 **/
	 function getList($pageLimit, $fileld='*' ,$where='', $order=' order by id desc ') {
	 	if($where){
			$where=' where '.$where;
		}
		$this->db->open('select * from '.$this->tName.' '.$where.' '.$order , $pageLimit['rowFrom'],$pageLimit['rowTo']);
		$result = array();
		while ($rs = $this->db->next()) {
			$result[] = $rs;
		}
		return $result;
	 }
	
	/**
	 * ɾϢ
	 * @param mixed $ids IDб
	 * @access public
	 * @return bool
	 */
	function delete($ids) {
		if (is_array($ids)) {
			$ids = implode(',',$ids);
			$where = ' id in (' . $ids . ')';
		} else {
			$where = ' id=' . intval($ids);
		}
		return $this->db->execute('delete from '.$this->tName.' where ' . $where);
	}
	
	/**
	 * ״̬ ɾ
	 * @param mixed $members ûID
	 * @access public
	 * @return bool
	 */
	function changeStatus($ids,$status) {
		if (is_array($ids)) {
			$ids = implode(',',$ids);
			$where = ' id in (' . $ids . ')';
		} else {
			$where = ' id=' . intval($ids);
		}
		return $this->db->execute('update '.$this->tName.' set status = '.$status.' where ' . $where);
	}
	/**
	 * ȡϸϢ
	 * @access public
	 * @param int $id
	 * @return array 
	 */
	function getInfo($id,$field = '*'){
		return $this->db->getValue('select '.$field.' from '.$this->tName.' where id =' .$id);
	}
	/**
	 * ȡ
	 * @access public
	 * @return int
	 */
	function getCount($where = '') {
		if($where){
			$where=' where '.$where;
		}
		return $this->db->getValue('select count(*) from '.$this->tName.' '.$where );
	}
	/**
	 * ȡίиҵķԴ
	 * 
	 */
	function getMyConsign($member_id)
	{
		$sql = "select DISTINCT consign_id from ".$this->tNameBroker." where broker_id='".$member_id."'";
		return $this->db->select($sql);
	}
	/**
	 * ȡ
	 * @access public
	 * @return int
	 */
	function getCountBroker($where = '') {
		if($where){
			$where=' where '.$where;
		}
		$sql ="select count(*) from ".$this->tName ." as c left join ".$this->tNameBroker." as b on c.id = b.consign_id ".$where ;
		
		return $this->db->getValue($sql);
	}
	/**
	 * ȡϢб ˲쿴ίиԼҳ
	 * @access public
	 * 
	 * @param array $pageLimit
	 * @return array
	 **/
	 function getListBroker($pageLimit, $fileld='*' ,$where='', $order='') {
	 	if($where){
			$where=' where '.$where;
		}
		
		$sql = "select c.id as cid ,c.*,b.id as bid,b.* from ".$this->tName ." as c 
			left join ".$this->tNameBroker." as b on c.id = b.consign_id ".$where.$order;
		$this->db->open($sql , $pageLimit['rowFrom'],$pageLimit['rowTo']);
		$result = array();
		while ($rs = $this->db->next()) {
			$result[] = $rs;
		}
		return $result;
	 }
	 /**
	  * ɾίиԼļ¼
	  *
	  * @param int $bid
	  */
	 function deleteBroker($bid)
	 {
	 	return $this->db->execute('update '.$this->tNameBroker.' set isdel=1 where id= ' . $bid);
	 }
	 
	 /**
	  * ɾίиԼļ¼()
	  *
	  * @param int $bid
	  */
	 function deleteBrokerc($bid)
	 {
	 	return $this->db->execute('delete from '.$this->tNameBroker.' where id=' . $bid);
	 }
	 
	 /**
	  * Դ
	  *
	  * @param int $member_id
	  * @param int $consign_id
	  */
	 function accept($member_id,$consign_id)
	 {
	 	//1Ѹ÷Դίм¼Ϊ
		$this->db->execute("update ".$this->tName." set consign_status = 2 where id=".$consign_id);
	 	//2Ѹþ˹Դίо˱¼Ϊ
	 	$this->db->execute("update ".$this->tNameBroker." set status =1 where consign_id =".$consign_id." and broker_id=".$member_id);
	 }
	 /**
	  * ˲Դ
	  *
	  * @param int $member_id
	  * @param int $consign_id
	  */
	 function decline($member_id,$consign_id,$remark)
	 {
	 	//1Ҫ״̬
	 	//2Ѹþ˹Դίо˱¼Ϊ, ¼
	 	$this->db->execute("update ".$this->tNameBroker." set status =2,remark='".$remark."' where consign_id =".$consign_id." and broker_id=".$member_id);
	 }
	 /**
	 * ȡϸϢ
	 * @access public
	 * @param int $id
	 * @return array 
	 */
	function getInfoByHouseId($house_id,$owner_id,$consign_type){
	return $this->db->getValue('select * from '.$this->tName.' where house_id =' .$house_id.' and owner_id = '.$owner_id. ' and consign_type='.$consign_type);
	}
	
	
	function getInfoByHouseIdc($house_id,$consign_type){
	return $this->db->getValue('select * from '.$this->tName.' where house_id =' .$house_id.' and consign_type='.$consign_type);
	}
	/**
	 * ˲쿴ίҳ
	 * @param int $consign_id
	 * @return  array
	 */
	function getConsignBroker($consign_id){
		return $this->db->select("select * from ".$this->tNameBroker." where consign_id =".$consign_id);
	}
}
?>